<?php

class User {

	private $id;
	private $priviledges;
	private $content;

	function handelEvent($event) {
		$this->notify($event->getUserName(), new UserContactDetails(), $event->getMessage());

	}

	function notify($userName, $contactDetails, $message) {

		$messageBody = 'Dear ' . $userName;
		$messageBody .= '( ' . $contactDetails->getStreetNumber() . ' ' .
				$contactDetails->getStreetName() . ').';
		$messageBody .= $message;

		$notificationService->sendSMS($contactDetails->getPhoneNubmer(), $messageBody);
	}

	function delete() {
		systemDelete($this->id);
		// system command to delete user with $id
	}

	function update() {
		// system command to update user identified by $id
		// with $priviledges and $content
		systemUpdate($this->id, $this->priviledges, $this->content);
	}

	function restrict() {
		// restric priviledges of a user
		systemRestrictUser($this->id, $this->priviledges);
	}

	function censorContent() {
		// censor user content
		systemCensor($this->id, $this->content);
	}

	public function setPriviledges($priviledges) {
		$this->priviledges = $priviledges;
	}

	public function setContent($content) {
		$this->content = $content;
	}



}

?>
